#ifndef JEXIF_H
#define JEXIF_H

#include <jpeglib.h>

#define EXIF_SAW_ORIENTATION           0x0001
#define EXIF_SAW_IMAGEWIDTH            0x0002
#define EXIF_SAW_IMAGELENGTH           0x0004
#define EXIF_SAW_COMPRESSION           0x0008
#define EXIF_SAW_JPEGIFOFFSET          0x0010
#define EXIF_SAW_JPEGIFBYTECOUNT       0x0020
#define EXIF_SAW_ERROR                 0x0040

typedef struct
{
    unsigned int SawWhat;
    unsigned int Orientation;
    unsigned int ImageWidth;
    unsigned int ImageLength;
    unsigned int Compression;
    unsigned int JpegIFOffset;
    unsigned int JpegIFByteCount;
    unsigned int App1Offset;
	unsigned char	Datetime[20];
    int ReverseByteOrder;
    int ExifLength;
    int IFD0_Count;
    int IFD1_Count;
} JPEG_EXIF_Info;

typedef struct
{
	struct jpeg_decompress_struct cInfo;
	JPEG_EXIF_Info EXIF_Info;
} jpeg_decompress_struct_ext;

#endif
